'temperature logger Version 11 February 2017 (for 20X2)
'supports two DS18B20 temperature sensors (sensorA & sensorB)
'supports i2c LCD 20x4
'supports i2c DS3231 RTC
'supports multiple eeprom capacities up to 512Kbits

#picaxe 20x2

setfreq m64	'pgm must run at high speed due to 750msec conversion time of DS18B20's combined with 
		'program complexity and the need to update the dispaly every second. To achive this the DS18B20's
		'are read on alternate seconds ie. 1 sensor reading per second

pullup on	'20X2 - pins c.0 c.6 c.7 b.0 b.1 b.5 b.6 b.7 - switch pullups 


#rem
RAM used

$60 next LOGGED reading alarm secs
$61 next LOGGED reading alarm mins
$62 next LOGGED reading alarm hrs
$63 next LOGGED reading flag (0=don't log, 1=log)

$64 next reading alarm secs
$65 next reading flag (0=don't read, 1=read)
$66 toggle temperature sensor value 0=sensorA, 1=sensorB

$6A setalarmL sec_offset
$6B setalarmL min_offset
$6C setalarmL hrs_offset

$70 - $79 ascii character time registers
#endrem

'20X2 pin assignments
symbol BLsw    = pinC.0	'LCD backlight on/off

symbol syncSW  = pinB.0	'RTC sync switch (dual function)
symbol logSW   = pinB.0	'logging interval switch (dual function)

symbol dstSW   = pinB.1	'DST switch
symbol dumpSW  = pinC.6	'RS232 dump ALL switch
symbol resetSW = pinC.7	'minmax reset switch
symbol screenSW= pinB.6	'screen select switch

'pinC.2	'temperature sensor A DS18B20
'pinC.1	'temperature sensor B DS18B20
'pinC.5	'rs232 output pin

symbol WP= pinB.4		'EEPROM write protect
WP=1				'EEPROM write protection ON

'constants
symbol LCDaddress	=$7E		'i2c Address of LCD (A0, A1, A2 pulled high on PCF8574A) (NOTE...$4E for PCF8574)
symbol RTCaddress	=$D0		'DS3231 (or DS1307)
symbol EEPROMaddress=$AE	'24C32N mounted on DS3231 RTC board (A2,A1,A0 HIGH)
'symbol EEPROMaddress=$A8	'24LC512 or 24LC1025 (A2 High, A1,A0 LOW)
symbol PROM_range=$0FF8		'AT24C32 = 32Kbits  = 4096 bytes
'symbol PROM_range=$7FF8	'24LC256 = 256Kbits = 32768 bytes
'symbol PROM_range=$FFF0	'24LC512 = 512Kbits = 65536 bytes NOTE: need to subtract 16 bytes for 512/1024 kbit eeprom
					'due to IF statement 16 bit address overflow in rs232outall subroutine

symbol reading_interval=1	'temperature reading interval in secs
symbol lfee=10			'line feed char
symbol cret=13			'carriage return char
symbol dly=1			'i2c LCD delay constant (msec)


'temporary registers
symbol TW1=w15	'temporary WORD register
symbol TW3=w7	'temporary WORD register	
symbol TW2=w8	'temporary WORD register

'variables
symbol  dom=b21	'day of month decimal
symbol mnth=b22	'month decimal
symbol secs=b23	'secs decimal
symbol mins=b24	'mins decimal
symbol  hrs=b25	'hrs  decimal
symbol DSTvalue=b12 '0=DST no, 1=DST yes
symbol LOGint  =b13 'logging interval

symbol waddress=w5	'eeprom write address
waddress=0

symbol maxtemp=w13	'temporary word reg
symbol mintemp=w14	'temporary word reg

symbol Atemp=w16		'raw 2's compliment value from DS18B20 A
symbol Atempreal=w17	'converted real temperature value x10 (eg 205 = 20.5 degC)
symbol Atempmax=w18	'raw 2's complement value
symbol Atempmaxreal=w19	'converted real temperature value x10 (eg 205 = 20.5 degC)
symbol Atempmin=w20	'raw 2's complement value
symbol Atempminreal=w21	'converted real temperature value x10 (eg 205 = 20.5 degC)

symbol Btemp=w22		'raw 2's complement value from DS18B20 B
symbol Btempreal=w23	'converted real temperature value x10 (eg 205 = 20.5 degC)
symbol Btempmax=w24	'raw 2's complement value
symbol Btempmaxreal=w25	'converted real temperature value x10 (eg 205 = 20.5 degC)
symbol Btempmin=w26	'raw 2's complement value
symbol Btempminreal=w27	'converted real temperature value x10 (eg 205 = 20.5 degC)

'--------------------------------------------------------
'these settings are for the LCM1602 LCD i2c daughterboard
'with a fixed address A0,A1,A2 permanently tied high
Symbol  DB4= bit4	' Data 4
Symbol  DB5= bit5	' Data 5
Symbol  DB6= bit6	' Data 6
Symbol  DB7= bit7	' Data 7
Symbol  RS = bit0	' 0 = Command   1 = Data
Symbol  RD = bit1	' 0 = Write     1 = Read
Symbol  E  = bit2	' 0 = Idle      1 = Active
Symbol  BL = bit3	' BACK LIGHT bit assignment

symbol  RSCMD     = 0         ' Select Command register
symbol  RSDAT     = 1         ' Select Data register
'--------------------------------------------------------
table  $0,("10 sec",10,0,0)	'logging interval text descriptor and
table $10,("30 sec",30,0,0)	'corresponding setalarmL sec, min and hrs offset values
table $20,(" 1 min",0,1,0)	
table $30,(" 2 min",0,2,0)
table $40,(" 5 min",0,5,0)
table $50,("10 min",0,10,0)
table $60,("15 min",0,15,0)
table $70,("30 min",0,30,0)
table $80,("60 min",0,0,1)
'-------------------------------------------------------

read 255,DSTvalue	'fetch & check DSTvalue from EEPROM
if DSTvalue>1 then :write 255,0 :endif

read 254,LOGint	'fetch active logging interval TABLE address from EEPROM ($0, $10, $20, .... $80)

'initialise
gosub initLCD
gosub LCD1static
gosub minmax_reset	'set initial min & max temperature values sensor A & sensor B

poke $63,1		'set LOGGED reading flag
poke $65,1		'set next reading flag
'---------------------------------------------------------------------------------
'#################################################################################

main:

	gosub check_switches		'check for switch activity
	gosub gettime			'read RTC
	gosub check_alarm_points	'check for next reading AND next logged reading times 
	
	
	'time for next reading ?
	'-----------------------
	peek $65,b3		'fetch next reading flag
	peek $66,b4		'active temperature sensor (0=sensorA, 1=sensorB)
	
	if b3=1 AND b4=0 then :poke$65,0 :poke$66,1 :gosub setalarmR :gosub read_temperatureA :gosub minmaxA :gosub LCD1dynamic :goto L600 :endif

	if b3=1 AND b4=1 then :poke$65,0 :poke$66,0 :gosub setalarmR :gosub read_temperatureB :gosub minmaxB :gosub LCD1dynamic :endif

	L600:
	
	'time for next LOGGED reading ?
	'------------------------------
	peek $63,b3		'fetch next logged reading flag
	if b3=1 then :poke $63,0 :gosub setalarmL :gosub eepromwrite :endif

goto main

'###############################################################################

'---------------------------
'---------------------------
'SUBROUTINES START HERE ****
'---------------------------
'---------------------------

check_switches:
'this subroutine checks for switch activity

	'SCREEN
	if screenSW=0 then :gosub do_screenSW :endif
	
	'RTC SYNC
	if syncSW=0 then :gosub do_syncSW :endif
	
	'DST
	if dstSW=0 then :gosub do_dstSW :endif
	
	'rs232DUMP 
	if dumpSW=0 then :gosub do_dumpSW :endif

	'min max reset
	if resetSW=0 then :gosub do_resetSW :endif

return
'-------------------------------------------------------

do_screenSW:
'this subroutine displays the LCD2 screen and allows setting of the 
'logged reading interval

	gosub LCD2static
	gosub LCD2dynamic
	
	L920:
	pause 80
	if screenSW=0 then :goto L920 :endif	'loop here until screenSW is released

L930:

	'increment log interval table location, save to eeprom
	if logSW = 0 then :LOGint=LOGint + $10 :if LOGint>$80 then :LOGint=$0 :endif :write 254,LOGint :endif	
	gosub LCD2dynamic
	pause 6000	'0.75 sec @64MHz 20X2
	if screenSW=1 then :goto L930 :endif

	gosub LCD1static
	poke $63,1				'set LOGGED reading flag
	poke $65,1				'set next reading flag
	
	L940:
 	pause 80
	if screenSW=0 then :goto L940 :endif	'loop here until screenSW is released

return
'-----------------------------------------------------------------------

'----------------------------------------------------------------------
do_dstSW:
'this subroutine changes the RTC hrs value up or down 1 hour

	'here we alter BCD hrs according to DST value
	'first change BCD hrs to BINARY, add or subtract an hour, convert back to BCD
	'write new value to RTC
	hi2csetup i2cmaster, RTCaddress,i2cFAST_64,i2cbyte	'set RTC as active i2c device then read 6 bytes of data
	
	read 255,DSTvalue 	'restore DSTvalue from eeprom

	if DSTvalue>1 then :DSTvalue=0 :endif	'out of range error check

	if DSTvalue =0 then :DSTvalue=1 else :DSTvalue=0 :endif	'toggle DSTvalue

	if DSTvalue=1 then :goto L830 :endif

	if hrs=$00 then :hrs=$17 else :hrs=hrs-$01 :endif	'subtract an hour (note 0x17=23 BCD)
	goto L840
	
	L830:
	if hrs=$17 then :hrs=$00 else :hrs=hrs+$01 :endif	'add an hour (note 0x17=23 BCD)

	L840:
	b19= BINTOBCD hrs		'convert hrs  to BCD value
	hi2cout $02, (b19)	'write new hrs BCD value to RTC
	write 255,DSTvalue	'store new DSTvalue in eeprom
	
	L850:
	pause 80
	if dstSW=0 then :goto L850 :endif	'loop here until dstSW is released
	
	poke $63,1				'set LOGGED reading flag
	poke $65,1				'set next reading flag
	
return
'--------------------------------------------------------------

do_syncSW:
'this subroutine sets the RTC secs value to 30
  
	'pressing then releasing the syncSW will cause the RTC sec value to be forced to 30
	hi2csetup i2cmaster, RTCaddress,i2cFAST_64,i2cbyte	'set RTC as active i2c device then read 6 bytes of data
	
	L820:
	pause 80
	if syncSW=0 then :goto L820 :endif	'loop here until syncSW is released
	
	hi2cout $00, ($30)		'set RTC secs to 30
	
	poke $63,1				'set LOGGED reading flag
	poke $65,1				'set next reading flag
	
return
'-------------------------------------------------------------

do_dumpSW:
'this subroutine dumps all eeprom data to the rs232 port

	for b18=0 to 255
		pause 40
		if dumpSW=1 then :goto L800 :endif
	next b18

	gosub LCD3static
	gosub rs232outall	'if button pressed for ~ 4secs
	
	poke $63,1		'set LOGGED reading flag
	poke $65,1		'set next reading flag
	gosub LCD1static

L800:
return
'-------------------------------------------------------------

do_resetSW:
'this subroutine conditions the resetSW and then calls minmax_reset

	'for b18=0 to 10
		'pause 40
		'if resetSW=1 then :goto L710 :endif
	'next b18

	gosub minmax_reset
	gosub LCD1dynamic
	
	L700:
	pause 80
	if resetSW=0 then :goto L700 :endif

	'L710:
	poke $63,1		'set LOGGED reading flag
	poke $65,1		'set next reading flag
	
return
'------------------------------------------------------------
minmax_reset:
'this subroutine resets min a max temps to ambient temp

gosub read_temperatureA
gosub read_temperatureB

Atempmax=Atemp 'all raw numbers (2's compliment)
Atempmin=Atemp
Btempmax=Btemp
Btempmin=Btemp

w1=Atempmax :gosub tconvert:Atempmaxreal=TW3	'all real numbers
w1=Btempmax :gosub tconvert:Btempmaxreal=TW3
w1=Atempmin :gosub tconvert:Atempminreal=TW3
w1=Btempmin :gosub tconvert:Btempminreal=TW3

return
'--------------------------------------------------------------

minmaxA:
'checks for new min and max readings on sensor A

TW1=Atemp : maxtemp=Atempmax : mintemp=Atempmin
gosub minmax_common
Atempmax=maxtemp : Atempmin=mintemp	

w1=Atempmax :gosub tconvert :Atempmaxreal=TW3	'convert 2's compliment temperatures to real numbers
w1=Atempmin :gosub tconvert :Atempminreal=TW3

return
'-----------------------------------------------------------------

minmaxB:
'checks for new min max reading on sensor B

TW1=Btemp : maxtemp=Btempmax : mintemp=Btempmin
gosub minmax_common
Btempmax=maxtemp : Btempmin=mintemp

w1=Btempmax :gosub tconvert :Btempmaxreal=TW3	'convert 2's compliment temperatures to real numbers
w1=Btempmin :gosub tconvert :Btempminreal=TW3

return
'-----------------------------------------------------------------

minmax_common:
'common code to minmaxA & minmaxB subroutines

'---------------------
'first check maximum's
'highest +ve temp=125 =$07D0, lowest -ve temp=-55 =$FC90 see DS18B20


'condition 1 (-+) 
if TW1 >= $FC90 AND maxtemp <= $07D0 then :goto mincheck :endif

'condition 2 (+-)
if TW1 <= $07D0 AND maxtemp >= $FC90 then :maxtemp=TW1 :goto mincheck :endif

'condition 3 and 4 (++ & --)
if TW1 > maxtemp then :maxtemp=TW1 :endif

'-------------------
'now check minimum's
mincheck:

'condition 1 (+-)
if TW1 <= $07D0 AND mintemp >= $FC90 then :return :endif

'condition 2 (-+)
if TW1 >= $FC90 AND mintemp <= $07D0 then :mintemp=TW1 :return :endif

'condition 3 and 4 (++ & --)
if TW1 < mintemp then :mintemp=TW1 :endif

return
'-----------------------------------------------------------------------------------

check_alarm_points:
'this subroutine checks for next reading, next logged reading & 3am reset times

	'next reading ?
	'--------------
	
	peek $64,b6
	
	if b6=secs then :poke $65,1 :endif
		
	'next LOGGED reading ?
	'---------------------
		
	peek $60,b6		'restore next LOGGED reading alarm settings
	peek $61,b7
	peek $62,b8
	
	if b6=secs AND b7=mins AND b8=hrs then :poke $63,1 :endif
	
	'3am RESET
	'---------
	
	if secs=0 AND mins=0 AND hrs=3 then :gosub minmax_reset :endif	'RESET MIN & MAX to ambient value at 3am

return
'---------------------------------------------------------------------------------------------------------------

read_temperatureA:
'read value from DS18B20 sensorA

'note that -ve temperatures are returned as a 2's complement
'note w1 >>> b3&b2 >>> bit31 to bit16
	
	readtemp12 C.2,Atemp	'read sensor A 
		
	'convert sensor A reading for display purposes and store in ram 
	w1=Atemp
	gosub tconvert	'export w1 (b2,b3)
	Atempreal =TW3
		
return
'-----------------------------------------------------------------------------------

read_temperatureB:
'read value DS18B20 sensorB

'note that -ve temperatures are returned as a 2's complement
'note w1 >>> b3&b2 >>> bit31 to bit16

	readtemp12 C.1,Btemp	'read sensor B
	
	'convert sensor B reading for display purposes and store in ram
	w1=Btemp
	gosub tconvert
	Btempreal=TW3

return
'----------------------------------------------------------------------------------- 		

tconvert:
'this subroutine converts 2's compliment values to real values for display purposes 

'if temperature is -ve then convert 2's compliment
'import w1, export TW3, b9 temperature integer, b7 temperature fraction
		
	if w1 >= $FC90 then :w1=w1-1 :w1= NOT w1 :endif

	b7=b3&$07*16
	b8=b2&$F0/16
	b9=b7+b8	'b9 temp - interger part (whole degrees)

	w2=bit16*625
	w2=bit17*1250+w2
	w2=bit18*2500+w2
	w2=bit19*5000+w2
	b7=w2/1000	'b7 temp - fractional digit

	'TW3 = (whole deg *10) + fractional digit
	'it is a whole number eg 27.6 degC = 276, 0.5 degC = 5
	TW3=b9*10
	TW3=TW3 + b7
	
return
'--------------------------------------------------------------------------------

gettime:
'this routine reads the RTC and converts BCD values to decimal values
	
hi2csetup i2cmaster, RTCaddress,i2cFAST_64,i2cbyte	'set RTC as active i2c device then read 6 bytes of data

hi2cin 0,(b18,b19,b20,b4,b4,b5)		'b18=secs,b19=mins,b20=hrs,b4=dom,b5=mnth
								
	'convert bcd time to ascii chars for display purposes
	'----------------------------------------------------
	bcdtoascii b18,b6,b7			
	poke $70,b6 :poke $71,b7	'$70=sec tens, $71=sec units
		
	bcdtoascii b19,b6,b7
	poke $72,b6 :poke $73,b7	'$72=min tens, $73=min units
		
	bcdtoascii b20,b6,b7
	poke $74,b6 :poke $75,b7	'$74=hrs tens, $75=hrs units
		
	bcdtoascii b4,b6,b7
	poke $76,b6 :poke $77,b7	'$76=dom tens, $77=dom units
		
	bcdtoascii b5,b6,b7
	poke $78,b6 :poke $79,b7	'$78=month tens, $79=month units
	
	
	'convert bcd time to binary value for time calculation purposes and eeprom storage
	'---------------------------------------------------------------------------------
	b6=b18 & $F0 /16*10
	secs=b18 & $0F + b6	'decimal secs
		
	b6=b19 & $F0 /16*10	
	mins=b19 & $0F + b6	'decimal mins
		
	b6=b20 & $F0 /16*10	'decimal hours
	hrs=b20 & $0F + b6
		
	b6=b4 & $F0 /16*10	
	dom=b4 & $0F + b6		'decimal dom
	
	b6=b5 & $F0 /16*10	
	mnth=b5 & $0F + b6	'decimal month
	
return
'------------------------------------------------------------------------

eepromwrite:
'this subroutine writes logged date, time and temperature values to eeprom
'temperature values stored in eeprom are 2's compliment numbers

WP=0	'write protect off

	hi2csetup i2cmaster, EEPROMaddress,i2cfast_64,i2cword	'set eeprom as active i2c device

	hi2cout waddress, (mins,hrs,dom,mnth,b32,b33,b44,b45)	'i2c write (8 bytes) Atemp w16=b32,b33 Btemp w22=b44,b45
	pause 40								'eeprom write cycle complete = 5msec @ 64MHz (20X2 default=8MHz)	
	
	waddress=waddress+8						'increment by 8,not 6,due to eeprom write 
										'page buffer limit, see i2c tutorial.pdf
	hi2cout waddress, ($ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff)	'clear the next 8 memory locations as a marker			
	
WP=1	'write protect on

	if waddress = PROM_range then :waddress=0 :endif	'test for end of memory and reset if necessary
	
return
'-----------------------------------------------------------------------

setalarmL:
'this section of code sets the alarm time for the next LOGGED reading
	
	'use the current reading time and add the required offset to get the next reading time
	'registers affected b6,b7,b9
	
	b18=secs
	b19=mins
	b20=hrs
	
	Add_Secs:

		b16=LOGint + $06
		readtable b16,b17					'fetch sec_offset from TABLE
		
		b18 = b18 + b17					'change the offset according to the next reading time
		if b18 < 60 then :goto Add_Mins :endif
		b18 = b18 - 60					'secs is now greater than 60 so add 1 to minute instead
		b19 = b19 + 1

	Add_Mins:

		inc b16
		readtable b16,b17					'fetch min_offset from TABLE
		
		b19 = b19 + b17					'change the offset according to the next reading time
		if b19 < 60 then :goto Add_Hours :endif
		b19 = b19 - 60					'mins is now greater than 60 so add 1 to hour instead
		b20 = b20 + 1

	Add_Hours:

		inc b16
		readtable b16,b17					'fetch hrs_offset from TABLE
		
		b20 = b20 + b17					'change the offset according to the next reading time
		if b20 < 24 then :goto label2 :endif
		b20 = b20 - 24					'hours is now greater than 24 so make correction

	label2:
		poke $60,b18					'save next LOGGED reading alarm settings
		poke $61,b19
		poke $62,b20
return
'-----------------------------------------------------------------------

setalarmR:
'this subroutine sets the alarm time for the next reading
		
	b18 = secs + reading_interval	'reading interval normally set to 1 sec	
	if b18 < 60 then :poke $64,b18 :return else :b18=b18-60 :poke $64,b18 :return :endif
				
return
'-------------------------------------------------------------------------------------------

rs232outall:
'this subroutine outputs stored eeprom data in CSV format to the rs232 port
	
	if waddress=0 then :return :endif

	serout c.5,N38400_64, ("count,date,time,sensorA,sensorB",cret,lfee)

	hi2csetup i2cmaster, EEPROMaddress,i2cfast_64,i2cword	'set eeprom as active i2c device

		
	for TW1=0 to PROM_range step 8

		hi2cin TW1, (b18,b19,b4,b5,b2,b3,b16,b17)		'read 8 mem bytes (b2,b3 & b16,b17 raw 2's compliment temps)
		
		'serout log count & logged date
		'------------------------------
		bintoascii b4,b6,b6,b7					'serial out of ascii dom chars
		serout c.5,N38400_64, (#TW1,",",b6,b7)
	
		bintoascii b5,b6,b6,b7					'serial out of ascii mnth chars
		serout c.5,N38400_64, ("/",b6,b7,",")
		
		'serial out logged time
		'----------------------
		bintoascii b19,b6,b6,b7					'serial out of ascii hours chars (use b6 twice since running
		serout c.5,N38400_64, (b6,b7)				'out of available registers)
	
		bintoascii b18,b6,b6,b7					'serial out of ascii mins chars
		serout c.5,N38400_64, (":",b6,b7,",")
	
		'serout logged temperature
		'-------------------------
		
		'Atemp
		w1=w1	'b2,b3
		if w1 <= $07D0 then :b6=43 else :b6=45 :endif
		gosub tconvert	'export w1 (b2,b3), import b9 temperature integer, b7 temperature fraction
		serout c.5,N38400_64, (b6,#b9,".",#b7,",")
		
		'Btemp
		w1=w8	'b16,b17
		if w8 <= $07D0 then :b6=43 else :b6=45 :endif
		gosub tconvert	'export w1 (b2,b3), import b9 temperature integer, b7 temperature fraction
		serout c.5,N38400_64, (b6,#b9,".",#b7,cret,lfee)
		'---------------------------------------------------------------
	
	next TW1

	serout c.5,N38400_64, ("finish ----",cret,lfee,lfee)
	
return
'------------------------------------------

LCD1static:
'this code writes the static chars to LCD1 screen

HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_64, I2CBYTE
		
		b19 = $01 :gosub SendCmdByte	'clear LCD		
		
		'LINE1
		'-----
		b19 = $80 :gosub SendCmdByte	'set cursor
		
		for b20=0 to 2
		lookup b20,("Amb"),b19
		gosub SendDataByte
		next b20		
			
		'LINE2
		'-----
		b19= $C0 :gosub SendCmdByte	'set cursor
			for b20=0 to 2
			lookup b20,("Min"),b19
			gosub SendDataByte
			next b20
		
		'LINE3
		'-----
		b19= $94 :gosub SendCmdByte	'set cursor
			for b20=0 to 2
			lookup b20,("Max"),b19
			gosub SendDataByte
			next b20
		
return
'----------------------------------------------

LCD1dynamic:
'this code writes the dynamic chars to LCD1 screen

HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_64, I2CBYTE

		'LINE1
		'-----
		
		'sensor A
		'--------
		b19= $84 :gosub SendCmdByte	'set cursor
		
		'-------------------------------
		TW3=Atemp
		TW2=Atempreal
		gosub LCD_common
		
		'sensor B
		'--------
		b19= $8B :gosub SendCmdByte	'set cursor			
		
		'-------------------------------
		TW3=Btemp
		TW2=Btempreal
		gosub LCD_common
		
		'LINE2
		'-----
		
		'sensor A
		'--------
		b19= $C4 :gosub SendCmdByte	'set cursor
		
		TW3=Atempmin
		TW2=Atempminreal
		gosub LCD_common
		
		
		'sensor B
		'--------
		b19= $CB :gosub SendCmdByte	'set cursor
		
		TW3=Btempmin
		TW2=Btempminreal
		gosub LCD_common
				
		'LINE3
		'-----
		
		'sensor A
		'--------
		b19= $98 :gosub SendCmdByte	'set cursor
		
		TW3=Atempmax
		TW2=Atempmaxreal
		gosub LCD_common
		
		
		'sensor B
		'--------
		b19= $9F:gosub SendCmdByte	'set cursor			
		
		TW3=Btempmax
		TW2=Btempmaxreal
		gosub LCD_common
		
				
		'LINE4
		'-----
		b19= $D4 :gosub SendCmdByte	'set cursor
		
		'display time hh:mm:ss
		peek $74,b19 :gosub SendDataByte
		
		peek $75,b19 :gosub SendDataByte
		
		b19=":" 	 :gosub SendDataByte
		
		peek $72,b19 :gosub SendDataByte
		
		peek $73,b19 :gosub SendDataByte
		
		b19=":"	 :gosub SendDataByte
		
		peek $70,b19 :gosub SendDataByte
		
		peek $71,b19 :gosub SendDataByte
		
return
'-------------------------------------------------------------

LCD2static:
'this code writes the static chars of LCD2 screen

HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_64, I2CBYTE

		b19 = $01 :gosub SendCmdByte		'clear LCD		
		
		'LINE 1
		'------
		b19 = $80 :gosub SendCmdByte		'set cursor
			for b20 =0 to 8
			lookup b20,("LOGint = "),b19 
			gosub SendDataByte
		next b20
		
		'LINE2
		'-----
		b19 = $C0 :gosub SendCmdByte		'set cursor
			for b20=0 to 3
			lookup b20,("DST-"),b19
			gosub SendDataByte
			next b20
		
		'LINE3
		'-----
		b19 = $94 :gosub SendCmdByte		'set cursor
			for b20=0 to 8
			lookup b20,("log events "),b19
			gosub SendDataByte
			next b20
		
return
'-------------------------------------------------------------

LCD2dynamic:
'this code writes the dynamic chars of LCD2 screen
		
		'LINE 1
		'------
		b19 = $89 :gosub SendCmdByte			'set cursor
	
		b20=LOGint
		for b17=0 to 5
			readtable b20,b19
			gosub SendDataByte
			inc b20
		next b17

		'LINE2
		'-----
		b19 = $C4 :gosub SendCmdByte			'set cursor
		
		BINTOASCII DSTvalue,b17,b18,b19		'just send b19
		gosub SendDataByte
		
		'LINE3
		'-----
	 	b19 = $9F :gosub SendCmdByte			'set cursor
		
		w7=waddress/8
		BINTOASCII w7,b6,b7,b16,b17,b18		'display log event number
		b19=b6  :gosub SendDataByte
		b19=b7  :gosub SendDataByte
		b19=b16 :gosub SendDataByte
		b19=b17 :gosub SendDataByte
		b19=b18 :gosub SendDataByte
			
return
'------------------------------------------------------------

LCD3static:
'LCD3 screen RS232 DUMP MESSAGE
HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_64, I2CBYTE

		b19 = $01 :gosub SendCmdByte	'clear LCD
		
		'LINE1
		'-----
		b19 = $80 :gosub SendCmdByte	'set cursor
		
		for b18=0 to 19
			lookup b18,("RS-232 DUMP ... WAIT"),b19
			gosub SendDataByte 
		next b18

return
'-------------------------------------------------------------

LCD_common:
'common code to other LCD subroutines

		if TW3 <= $07D0 then :b19="+" else :b19="-" :endif	'set displayed temperature sign
		gosub SendDataByte
				
		bintoascii TW2, b31,b30,b4,b5,b6	'convert to ascii chars
		b19=b4  :gosub SendDataByte
		b19=b5  :gosub SendDataByte
		b19="." :gosub SendDataByte		
		b19=b6  :gosub SendDataByte

return
'-------------------------------------------------------------

initLCD:
'initialise LCD

HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_64, I2CBYTE

	b19=$33 :gosub SendInitCmdByte	'#1
	b19=$32 :gosub SendInitCmdByte	'#2
	b19=$28 :gosub SendInitCmdByte	'#3
	b19=$0C :gosub SendInitCmdByte	'#4
	b19=$06 :gosub SendInitCmdByte	'#5
	b19=$01 :gosub SendInitCmdByte	'#6
	
      #rem
	' Nibble commands - To initialise 4-bit mode
      #1 - $33 ; %0011---- %0011----   8-bit / 8-bit
      #2 - $32 ; %0011---- %0010----   8-bit / 4-bit

      ' Byte commands - To configure the LCD

      #3 - $28 ; %00101000 %001LNF00   Display Format
      #4 - $0C ; %00001100 %00001DCB   Display On
      #5 - $06 ; %00000110 %000001IS   Cursor Move

                          ; L : 0 = 4-bit Mode    1 = 8-bit Mode
                          ; N : 0 = 1 Line        1 = 2 Lines
                          ; F : 0 = 5x7 Pixels    1 = N/A
                          ; D : 0 = Display Off   1 = Display On
                          ; C : 0 = Cursor Off    1 = Cursor On
                          ; B : 0 = Cursor Steady 1 = Cursor Flash
                          ; I : 0 = Dec Cursor    1 = Inc Cursor
                          ; S : 0 = Cursor Move   1 = Display Shift

      #6 - $01 ; Clear Screen

	#endrem
	

     
return

'=============================================================================

SendInitCmdByte:

      pause dly				'see HD44780 spec

SendCmdByte:

      RS  = RSCMD				'send to Command register
	RD = 0				'write to the display
       
SendDataByte:

      BL=NOT BLsw				'LCD backlight is ON when BLsw is in down position (BLsw=0)				
      
      DB4 = b19/ %00010000		'send MSB out first
      DB5 = b19/ %00100000
      DB6 = b19/ %01000000
      DB7 = b19/ %10000000
      

      E   = 0 : HI2cOut( b0 )		'pulse E high
	E   = 1 : HI2cOut( b0 )
	E   = 0 : HI2cOut( b0 )
      pause dly				'see HD44780 spec

      DB4 = b19/ %00000001		'send LSB out second
      DB5 = b19/ %00000010
      DB6 = b19/ %00000100
      DB7 = b19/ %00001000

      E   = 0 : HI2cOut( b0 )		'pulse E high
      E   = 1 : HI2cOut( b0 )
      E   = 0 : HI2cOut( b0 )
      pause dly				'pause 5msec (@16MHz = 5x2=10) as per HD44780 spec

      RS  = RSDAT				'send to Data register Next

return














































































